// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package main

import (
	"path"
	"reflect"
	"runtime"

	"github.com/aws/aws-sdk-go-v2/service/accessanalyzer"
	"github.com/aws/aws-sdk-go-v2/service/account"
	"github.com/aws/aws-sdk-go-v2/service/acm"
	"github.com/aws/aws-sdk-go-v2/service/acmpca"
	"github.com/aws/aws-sdk-go-v2/service/amp"
	"github.com/aws/aws-sdk-go-v2/service/amplify"
	"github.com/aws/aws-sdk-go-v2/service/apigateway"
	"github.com/aws/aws-sdk-go-v2/service/apigatewayv2"
	"github.com/aws/aws-sdk-go-v2/service/appconfig"
	"github.com/aws/aws-sdk-go-v2/service/appflow"
	"github.com/aws/aws-sdk-go-v2/service/applicationautoscaling"
	"github.com/aws/aws-sdk-go-v2/service/appmesh"
	"github.com/aws/aws-sdk-go-v2/service/apprunner"
	"github.com/aws/aws-sdk-go-v2/service/appstream"
	"github.com/aws/aws-sdk-go-v2/service/appsync"
	"github.com/aws/aws-sdk-go-v2/service/athena"
	"github.com/aws/aws-sdk-go-v2/service/auditmanager"
	"github.com/aws/aws-sdk-go-v2/service/autoscaling"
	"github.com/aws/aws-sdk-go-v2/service/autoscalingplans"
	"github.com/aws/aws-sdk-go-v2/service/backup"
	"github.com/aws/aws-sdk-go-v2/service/backupgateway"
	"github.com/aws/aws-sdk-go-v2/service/batch"
	"github.com/aws/aws-sdk-go-v2/service/bedrock"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagent"
	"github.com/aws/aws-sdk-go-v2/service/budgets"
	"github.com/aws/aws-sdk-go-v2/service/cloudformation"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront"
	"github.com/aws/aws-sdk-go-v2/service/cloudhsmv2"
	"github.com/aws/aws-sdk-go-v2/service/cloudtrail"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatch"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs"
	"github.com/aws/aws-sdk-go-v2/service/codeartifact"
	"github.com/aws/aws-sdk-go-v2/service/codebuild"
	"github.com/aws/aws-sdk-go-v2/service/codecommit"
	"github.com/aws/aws-sdk-go-v2/service/codedeploy"
	"github.com/aws/aws-sdk-go-v2/service/codegurureviewer"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentity"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider"
	"github.com/aws/aws-sdk-go-v2/service/comprehend"
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizer"
	"github.com/aws/aws-sdk-go-v2/service/configservice"
	"github.com/aws/aws-sdk-go-v2/service/connect"
	"github.com/aws/aws-sdk-go-v2/service/costexplorer"
	"github.com/aws/aws-sdk-go-v2/service/databasemigrationservice"
	"github.com/aws/aws-sdk-go-v2/service/datapipeline"
	"github.com/aws/aws-sdk-go-v2/service/datasync"
	"github.com/aws/aws-sdk-go-v2/service/dax"
	"github.com/aws/aws-sdk-go-v2/service/detective"
	"github.com/aws/aws-sdk-go-v2/service/devopsguru"
	"github.com/aws/aws-sdk-go-v2/service/directconnect"
	"github.com/aws/aws-sdk-go-v2/service/directoryservice"
	"github.com/aws/aws-sdk-go-v2/service/dlm"
	"github.com/aws/aws-sdk-go-v2/service/docdb"
	"github.com/aws/aws-sdk-go-v2/service/dynamodb"
	"github.com/aws/aws-sdk-go-v2/service/dynamodbstreams"
	"github.com/aws/aws-sdk-go-v2/service/ec2"
	"github.com/aws/aws-sdk-go-v2/service/ecr"
	"github.com/aws/aws-sdk-go-v2/service/ecrpublic"
	"github.com/aws/aws-sdk-go-v2/service/ecs"
	"github.com/aws/aws-sdk-go-v2/service/efs"
	"github.com/aws/aws-sdk-go-v2/service/eks"
	"github.com/aws/aws-sdk-go-v2/service/elasticache"
	"github.com/aws/aws-sdk-go-v2/service/elasticbeanstalk"
	"github.com/aws/aws-sdk-go-v2/service/elasticloadbalancing"
	"github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2"
	"github.com/aws/aws-sdk-go-v2/service/elasticsearchservice"
	"github.com/aws/aws-sdk-go-v2/service/elastictranscoder"
	"github.com/aws/aws-sdk-go-v2/service/emr"
	"github.com/aws/aws-sdk-go-v2/service/eventbridge"
	"github.com/aws/aws-sdk-go-v2/service/firehose"
	"github.com/aws/aws-sdk-go-v2/service/fis"
	"github.com/aws/aws-sdk-go-v2/service/frauddetector"
	"github.com/aws/aws-sdk-go-v2/service/freetier"
	"github.com/aws/aws-sdk-go-v2/service/fsx"
	"github.com/aws/aws-sdk-go-v2/service/glacier"
	"github.com/aws/aws-sdk-go-v2/service/globalaccelerator"
	"github.com/aws/aws-sdk-go-v2/service/glue"
	"github.com/aws/aws-sdk-go-v2/service/grafana"
	"github.com/aws/aws-sdk-go-v2/service/guardduty"
	"github.com/aws/aws-sdk-go-v2/service/health"
	"github.com/aws/aws-sdk-go-v2/service/healthlake"
	"github.com/aws/aws-sdk-go-v2/service/iam"
	"github.com/aws/aws-sdk-go-v2/service/identitystore"
	"github.com/aws/aws-sdk-go-v2/service/imagebuilder"
	"github.com/aws/aws-sdk-go-v2/service/inspector"
	"github.com/aws/aws-sdk-go-v2/service/inspector2"
	"github.com/aws/aws-sdk-go-v2/service/invoicing"
	"github.com/aws/aws-sdk-go-v2/service/iot"
	"github.com/aws/aws-sdk-go-v2/service/kafka"
	"github.com/aws/aws-sdk-go-v2/service/kendra"
	"github.com/aws/aws-sdk-go-v2/service/keyspaces"
	"github.com/aws/aws-sdk-go-v2/service/kinesis"
	"github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2"
	"github.com/aws/aws-sdk-go-v2/service/kms"
	"github.com/aws/aws-sdk-go-v2/service/lakeformation"
	"github.com/aws/aws-sdk-go-v2/service/lambda"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelbuildingservice"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2"
	"github.com/aws/aws-sdk-go-v2/service/lightsail"
	"github.com/aws/aws-sdk-go-v2/service/location"
	"github.com/aws/aws-sdk-go-v2/service/macie2"
	"github.com/aws/aws-sdk-go-v2/service/memorydb"
	"github.com/aws/aws-sdk-go-v2/service/mq"
	"github.com/aws/aws-sdk-go-v2/service/mwaa"
	"github.com/aws/aws-sdk-go-v2/service/neptune"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall"
	"github.com/aws/aws-sdk-go-v2/service/networkmanager"
	"github.com/aws/aws-sdk-go-v2/service/opensearch"
	"github.com/aws/aws-sdk-go-v2/service/organizations"
	"github.com/aws/aws-sdk-go-v2/service/pi"
	"github.com/aws/aws-sdk-go-v2/service/pinpoint"
	"github.com/aws/aws-sdk-go-v2/service/polly"
	"github.com/aws/aws-sdk-go-v2/service/qldb"
	"github.com/aws/aws-sdk-go-v2/service/quicksight"
	"github.com/aws/aws-sdk-go-v2/service/ram"
	"github.com/aws/aws-sdk-go-v2/service/rds"
	"github.com/aws/aws-sdk-go-v2/service/redshift"
	"github.com/aws/aws-sdk-go-v2/service/rekognition"
	"github.com/aws/aws-sdk-go-v2/service/resiliencehub"
	"github.com/aws/aws-sdk-go-v2/service/resourcegroups"
	"github.com/aws/aws-sdk-go-v2/service/route53"
	"github.com/aws/aws-sdk-go-v2/service/route53domains"
	"github.com/aws/aws-sdk-go-v2/service/route53recoverycontrolconfig"
	"github.com/aws/aws-sdk-go-v2/service/route53recoveryreadiness"
	"github.com/aws/aws-sdk-go-v2/service/route53resolver"
	"github.com/aws/aws-sdk-go-v2/service/s3"
	"github.com/aws/aws-sdk-go-v2/service/s3control"
	"github.com/aws/aws-sdk-go-v2/service/s3tables"
	"github.com/aws/aws-sdk-go-v2/service/s3vectors"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker"
	"github.com/aws/aws-sdk-go-v2/service/savingsplans"
	"github.com/aws/aws-sdk-go-v2/service/scheduler"
	"github.com/aws/aws-sdk-go-v2/service/secretsmanager"
	"github.com/aws/aws-sdk-go-v2/service/securityhub"
	"github.com/aws/aws-sdk-go-v2/service/servicecatalog"
	"github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry"
	"github.com/aws/aws-sdk-go-v2/service/servicediscovery"
	"github.com/aws/aws-sdk-go-v2/service/servicequotas"
	"github.com/aws/aws-sdk-go-v2/service/ses"
	"github.com/aws/aws-sdk-go-v2/service/sesv2"
	"github.com/aws/aws-sdk-go-v2/service/sfn"
	"github.com/aws/aws-sdk-go-v2/service/shield"
	"github.com/aws/aws-sdk-go-v2/service/signer"
	"github.com/aws/aws-sdk-go-v2/service/snowball"
	"github.com/aws/aws-sdk-go-v2/service/sns"
	"github.com/aws/aws-sdk-go-v2/service/sqs"
	"github.com/aws/aws-sdk-go-v2/service/ssm"
	"github.com/aws/aws-sdk-go-v2/service/ssmincidents"
	"github.com/aws/aws-sdk-go-v2/service/ssoadmin"
	"github.com/aws/aws-sdk-go-v2/service/storagegateway"
	"github.com/aws/aws-sdk-go-v2/service/support"
	"github.com/aws/aws-sdk-go-v2/service/swf"
	"github.com/aws/aws-sdk-go-v2/service/timestreamwrite"
	"github.com/aws/aws-sdk-go-v2/service/transcribe"
	"github.com/aws/aws-sdk-go-v2/service/transfer"
	"github.com/aws/aws-sdk-go-v2/service/trustedadvisor"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice"
	"github.com/aws/aws-sdk-go-v2/service/waf"
	"github.com/aws/aws-sdk-go-v2/service/wafregional"
	"github.com/aws/aws-sdk-go-v2/service/wafv2"
	"github.com/aws/aws-sdk-go-v2/service/wellarchitected"
	"github.com/aws/aws-sdk-go-v2/service/workspaces"
	"github.com/aws/aws-sdk-go-v2/service/xray"

	"github.com/cloudquery/codegen/interfaces"
	"github.com/thoas/go-funk"
)

var clients = []any{
	&accessanalyzer.Client{},
	&account.Client{},
	&acm.Client{},
	&acmpca.Client{},
	&amp.Client{},
	&amplify.Client{},
	&apigateway.Client{},
	&apigatewayv2.Client{},
	&appconfig.Client{},
	&appflow.Client{},
	&applicationautoscaling.Client{},
	&appmesh.Client{},
	&apprunner.Client{},
	&appstream.Client{},
	&appsync.Client{},
	&athena.Client{},
	&auditmanager.Client{},
	&autoscaling.Client{},
	&autoscalingplans.Client{},
	&backup.Client{},
	&backupgateway.Client{},
	&batch.Client{},
	&bedrock.Client{},
	&bedrockagent.Client{},
	&budgets.Client{},
	&cloudformation.Client{},
	&cloudfront.Client{},
	&cloudhsmv2.Client{},
	&cloudtrail.Client{},
	&cloudwatch.Client{},
	&cloudwatchlogs.Client{},
	&codeartifact.Client{},
	&codebuild.Client{},
	&codecommit.Client{},
	&codedeploy.Client{},
	&codegurureviewer.Client{},
	&codepipeline.Client{},
	&cognitoidentity.Client{},
	&cognitoidentityprovider.Client{},
	&comprehend.Client{},
	&computeoptimizer.Client{},
	&connect.Client{},
	&configservice.Client{},
	&costexplorer.Client{},
	&databasemigrationservice.Client{},
	&datapipeline.Client{},
	&datasync.Client{},
	&dax.Client{},
	&detective.Client{},
	&devopsguru.Client{},
	&directconnect.Client{},
	&directoryservice.Client{},
	&dlm.Client{},
	&docdb.Client{},
	&dynamodb.Client{},
	&dynamodbstreams.Client{},
	&ec2.Client{},
	&ecr.Client{},
	&ecrpublic.Client{},
	&ecs.Client{},
	&efs.Client{},
	&eks.Client{},
	&elasticache.Client{},
	&elasticbeanstalk.Client{},
	&elasticloadbalancing.Client{},
	&elasticloadbalancingv2.Client{},
	&elasticsearchservice.Client{},
	&elastictranscoder.Client{},
	&emr.Client{},
	&eventbridge.Client{},
	&firehose.Client{},
	&fis.Client{},
	&frauddetector.Client{},
	&freetier.Client{},
	&fsx.Client{},
	&glacier.Client{},
	&globalaccelerator.Client{},
	&glue.Client{},
	&grafana.Client{},
	&guardduty.Client{},
	&health.Client{},
	&healthlake.Client{},
	&iam.Client{},
	&identitystore.Client{},
	&imagebuilder.Client{},
	&inspector.Client{},
	&inspector2.Client{},
	&invoicing.Client{},
	&iot.Client{},
	&kafka.Client{},
	&kendra.Client{},
	&keyspaces.Client{},
	&kinesis.Client{},
	&kinesisanalyticsv2.Client{},
	&kms.Client{},
	&lambda.Client{},
	&lakeformation.Client{},
	&lexmodelbuildingservice.Client{},
	&lexmodelsv2.Client{},
	&lightsail.Client{},
	&location.Client{},
	&macie2.Client{},
	&memorydb.Client{},
	&mq.Client{},
	&mwaa.Client{},
	&neptune.Client{},
	&networkfirewall.Client{},
	&networkmanager.Client{},
	&organizations.Client{},
	&opensearch.Client{},
	&pi.Client{},
	&pinpoint.Client{},
	&polly.Client{},
	&qldb.Client{},
	&quicksight.Client{},
	&ram.Client{},
	&rds.Client{},
	&redshift.Client{},
	&rekognition.Client{},
	&resiliencehub.Client{},
	&resourcegroups.Client{},
	&route53.Client{},
	&route53domains.Client{},
	&route53recoverycontrolconfig.Client{},
	&route53recoveryreadiness.Client{},
	&route53resolver.Client{},
	&s3.Client{},
	&s3control.Client{},
	&s3tables.Client{},
	&s3vectors.Client{},
	&sagemaker.Client{},
	&savingsplans.Client{},
	&scheduler.Client{},
	&secretsmanager.Client{},
	&securityhub.Client{},
	&servicecatalog.Client{},
	&servicecatalogappregistry.Client{},
	&servicediscovery.Client{},
	&servicequotas.Client{},
	&ses.Client{},
	&sesv2.Client{},
	&sfn.Client{},
	&shield.Client{},
	&signer.Client{},
	&snowball.Client{},
	&sns.Client{},
	&sqs.Client{},
	&ssm.Client{},
	&ssmincidents.Client{},
	&ssoadmin.Client{},
	&storagegateway.Client{},
	&support.Client{},
	&swf.Client{},
	&timestreamwrite.Client{},
	&transcribe.Client{},
	&transfer.Client{},
	&trustedadvisor.Client{},
	&vpclattice.Client{},
	&waf.Client{},
	&wafregional.Client{},
	&wafv2.Client{},
	&wellarchitected.Client{},
	&workspaces.Client{},
	&xray.Client{},
}

// Generate the service interfaces under in client/services for use with mockgen.
func main() {
	_, filename, _, ok := runtime.Caller(0)
	if !ok {
		panic("failed to get caller information")
	}
	err := interfaces.Generate(
		clients,
		path.Join(path.Dir(filename), "../client/services"),
		interfaces.WithSinglePackage("services"),
		interfaces.WithIncludeFunc(include),
		interfaces.WithExtraImports(extraImports),
	)
	if err != nil {
		panic(err)
	}
}

func include(m reflect.Method) bool {
	// these methods will be included despite not starting with an accepted prefix
	var exceptions = []string{
		"QuerySchemaVersionMetadata",
		"GenerateCredentialReport",
		"LookupEvents",
		"GenerateServiceLastAccessedDetails",
		"DeleteMessage",
		"ReceiveMessage",
		"HeadObject",
	}
	if funk.ContainsString(exceptions, m.Name) {
		return true
	}
	return interfaces.MethodHasAnyPrefix(m, []string{"List", "Get", "Describe", "Search", "BatchGet"})
}

func extraImports(_ reflect.Method) []string {
	return []string{"context"}
}
