// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package rds

import (
	"testing"

	"github.com/aws/aws-sdk-go-v2/service/rds"
	"github.com/aws/aws-sdk-go-v2/service/rds/types"
	"github.com/cloudquery/cloudquery/plugins/source/aws/client"
	"github.com/cloudquery/cloudquery/plugins/source/aws/client/mocks"
	"github.com/cloudquery/plugin-sdk/v4/faker"
	"github.com/golang/mock/gomock"
	"github.com/stretchr/testify/require"
)

func buildDBProxiesMock(t *testing.T, ctrl *gomock.Controller) client.Services {
	m := mocks.NewMockRdsClient(ctrl)
	proxy := types.DBProxy{}
	require.NoError(t, faker.FakeObject(&proxy))

	tags := rds.ListTagsForResourceOutput{}
	require.NoError(t, faker.FakeObject(&tags))

	m.EXPECT().DescribeDBProxies(gomock.Any(), gomock.Any(), gomock.Any()).
		Return(&rds.DescribeDBProxiesOutput{DBProxies: []types.DBProxy{proxy}}, nil)
	m.EXPECT().ListTagsForResource(gomock.Any(), gomock.Any(), gomock.Any()).
		Return(&tags, nil)

	buildDBProxyTargetGroupsMock(t, m, &proxy)
	buildDBProxyTargetsMock(t, m, &proxy)

	return client.Services{Rds: m}
}

func TestDBProxies(t *testing.T) {
	client.AwsMockTestHelper(t, DBProxies(), buildDBProxiesMock, client.TestOptions{})
}
