// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package plugin

import (
	"github.com/cloudquery/cloudquery/plugins/source/azure/client/spec"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/advisor"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/analysisservices"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/apimanagement"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/appcomplianceautomation"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/appconfiguration"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/applicationinsights"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/appservice"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/authorization"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/automation"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/azurearcdata"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/batch"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/billing"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/botservice"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/cdn"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/cognitiveservices"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/compute"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/confidentialledger"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/confluent"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/connectedvmware"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/consumption"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/containerapps"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/containerinstance"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/containerregistry"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/containerservice"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/cosmos"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/costmanagement"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/customerinsights"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/dashboard"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/databox"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/datadog"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/datafactory"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/datalakeanalytics"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/datalakestore"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/datamigration"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/desktopvirtualization"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/devhub"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/devops"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/devtestlabs"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/dns"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/dnsresolver"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/elastic"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/engagementfabric"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/eventgrid"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/eventhub"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/frontdoor"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/hanaonazure"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/hdinsight"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/healthbot"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/healthcareapis"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/hybridcompute"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/hybriddatamanager"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/keyvault"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/kusto"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/labservices"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/logic"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/machinelearning"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/maintenance"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/managedapplications"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/managementgroups"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/managementlocks"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/mariadb"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/marketplace"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/mediaservices"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/monitor"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/mysql"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/mysqlflexibleservers"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/netappfiles"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/network"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/networkfunction"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/nginx"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/notificationhubs"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/operationalinsights"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/peering"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/policy"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/policyinsights"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/portal"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/postgresql"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/postgresqlflexibleservers"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/postgresqlhsc"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/powerbidedicated"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/privatedns"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/providerhub"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/purview"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/quota"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/recoveryservices"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/redhatopenshift"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/redis"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/relay"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/reservations"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/resourcehealth"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/resources"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/saas"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/search"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/security"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/servicebus"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/servicefabric"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/servicefabricmanagedclusters"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/sql"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/sqlvirtualmachine"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/storage"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/storagecache"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/storagemover"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/storagesync"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/streamanalytics"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/subscription"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/support"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/synapse"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/trafficmanager"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/windowsiot"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/services/workloads"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/servicespremium/databricks"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/servicespremium/datacatalog"
	"github.com/cloudquery/cloudquery/plugins/source/azure/resources/servicespremium/datashare"
	premiumeventhub "github.com/cloudquery/cloudquery/plugins/source/azure/resources/servicespremium/eventhub"
	premiummonitor "github.com/cloudquery/cloudquery/plugins/source/azure/resources/servicespremium/monitor"
	"github.com/cloudquery/plugin-sdk/v4/premium"
	"github.com/cloudquery/plugin-sdk/v4/schema"
	"github.com/cloudquery/plugin-sdk/v4/transformers"
)

var freeTables = []string{
	"azure_compute_skus",
	"azure_cognitiveservices_resource_skus",
	"azure_security_assessments_metadata",
	"azure_peering_service_locations",
	"azure_authorization_provider_operations_metadata",
	"azure_network_bgp_service_communities",
	"azure_cosmos_locations",
	"azure_appservice_top_level_domains",
}

func getTables(s *spec.Spec) schema.Tables {
	list := []*schema.Table{
		advisor.RecommendationMetadata(),
		advisor.Recommendations(),
		advisor.Suppressions(),
		analysisservices.Servers(),
		apimanagement.Service(),
		appcomplianceautomation.Reports(),
		appconfiguration.ConfigurationStores(),
		applicationinsights.Components(),
		applicationinsights.WebTests(),
		appservice.CertificateOrders(),
		appservice.Certificates(),
		appservice.DeletedWebApps(),
		appservice.Domains(),
		appservice.Environments(),
		appservice.Plans(),
		appservice.Recommendations(),
		appservice.ResourceHealthMetadata(),
		appservice.StaticSites(),
		appservice.TopLevelDomains(),
		appservice.WebApps(),
		authorization.ClassicAdministrators(),
		authorization.ProviderOperationsMetadata(),
		authorization.RoleAssignments(),
		authorization.RoleDefinitions(),
		authorization.RoleManagementPolicyAssignments(),
		automation.Account(),
		azurearcdata.PostgresInstances(),
		azurearcdata.SqlManagedInstances(),
		azurearcdata.SqlServerInstances(),
		batch.Account(),
		billing.Accounts(),
		billing.EnrollmentAccounts(),
		billing.Periods(),
		botservice.Bots(),
		cdn.EdgeNodes(),
		cdn.ManagedRuleSets(),
		cdn.Profiles(),
		cognitiveservices.Accounts(),
		cognitiveservices.DeletedAccounts(),
		cognitiveservices.CommitmentPlans(),
		cognitiveservices.ResourceSKUs(),
		compute.AvailabilitySets(),
		compute.CapacityReservationGroups(),
		compute.CloudServices(),
		compute.DiskAccesses(),
		compute.DiskEncryptionSets(),
		compute.Disks(),
		compute.Galleries(),
		compute.Images(),
		compute.RestorePointCollections(),
		compute.SSHPublicKeys(),
		compute.SKUs(),
		compute.Snapshots(),
		compute.VirtualMachineScaleSets(),
		compute.VirtualMachines(),
		cosmos.DatabaseAccounts(),
		costmanagement.Views(),
		confidentialledger.Ledgers(),
		confidentialledger.Operations(),
		confluent.MarketplaceAgreements(),
		connectedvmware.Clusters(),
		connectedvmware.Datastores(),
		connectedvmware.Hosts(),
		connectedvmware.ResourcePools(),
		connectedvmware.VCenters(),
		connectedvmware.VirtualMachineTemplates(),
		connectedvmware.VirtualMachines(),
		connectedvmware.VirtualNetworks(),
		containerapps.ConnectedEnvironments(),
		containerapps.ContainerApps(),
		containerapps.Jobs(),
		containerapps.ManagedEnvironments(),
		containerapps.Operations(),
		containerinstance.ContainerGroups(),
		containerregistry.Registries(),
		containerservice.ManagedClusters(),
		containerservice.Snapshots(),
		cosmos.CassandraClusters(),
		cosmos.Locations(),
		cosmos.RestorableDatabaseAccounts(),
		consumption.BillingAccountBalances(),
		consumption.BillingAccountBudgets(),
		consumption.BillingAccountCharges(),
		consumption.BillingAccountEvents(),
		consumption.BillingAccountLegacyUsageDetails(),
		consumption.BillingAccountLots(),
		consumption.BillingAccountMarketplaces(),
		consumption.BillingAccountModernUsageDetails(),
		consumption.BillingAccountProfileCredits(),
		consumption.BillingAccountReservationRecommendations(),
		consumption.BillingAccountTags(),
		consumption.BillingProfileReservationDetails(),
		consumption.BillingProfileReservationRecommendations(),
		consumption.BillingProfileReservationSummaries(),
		consumption.BillingProfileReservationTransactions(),
		consumption.SubscriptionBudgets(),
		consumption.SubscriptionLegacyUsageDetails(),
		consumption.SubscriptionMarketplaces(),
		consumption.SubscriptionPriceSheets(),
		consumption.SubscriptionReservationRecommendations(),
		consumption.SubscriptionTags(),
		customerinsights.Hubs(),
		dashboard.Grafana(),
		databox.Jobs(),
		datacatalog.Catalogs(),
		datadog.MarketplaceAgreements(),
		datadog.Monitors(),
		datafactory.Factories(),
		datalakeanalytics.Accounts(),
		datalakestore.Accounts(),
		datamigration.Services(),
		datashare.Accounts(),
		desktopvirtualization.HostPools(),
		desktopvirtualization.ApplicationGroups(),
		desktopvirtualization.Workspaces(),
		devhub.Workflow(),
		devops.PipelineTemplateDefinitions(),
		devtestlabs.GlobalSchedules(),
		devtestlabs.Labs(),
		dns.Zones(),
		dnsresolver.DnsForwardingRulesets(),
		dnsresolver.DnsResolvers(),
		elastic.Monitors(),
		engagementfabric.Accounts(),
		eventgrid.TopicTypes(),
		eventhub.Namespaces(),
		premiumeventhub.Clusters(),
		frontdoor.FrontDoors(),
		frontdoor.ManagedRuleSets(),
		frontdoor.NetworkExperimentProfiles(),
		hanaonazure.SapMonitors(),
		hdinsight.Clusters(),
		healthbot.Bots(),
		healthcareapis.Services(),
		hybridcompute.PrivateLinkScopes(),
		hybriddatamanager.DataManagers(),
		keyvault.Keyvault(),
		keyvault.KeyvaultManagedHsms(),
		kusto.Clusters(),
		labservices.LabPlans(),
		labservices.Labs(),
		labservices.Operations(),
		labservices.Skus(),
		logic.IntegrationAccounts(),
		logic.Workflows(),
		machinelearning.Workspaces(),
		machinelearning.Operations(),
		machinelearning.Registries(),
		maintenance.Configurations(),
		maintenance.PublicMaintenanceConfigurations(),
		managedapplications.Applications(),
		managementgroups.ManagementGroups(),
		managementgroups.Entities(),
		managementlocks.ManagementLocks(),
		mariadb.Servers(),
		marketplace.PrivateStore(),
		mediaservices.MediaServices(),
		monitor.LogProfiles(),
		monitor.PrivateLinkScopes(),
		monitor.TenantActivityLogAlerts(),
		monitor.TenantActivityLogs(),
		monitor.Resources(),
		monitor.ActivityLogAlerts(),
		monitor.SubscriptionDiagnosticSettings(),
		monitor.AutoscaleSettings(),
		premiummonitor.ActionGroups(),
		premiummonitor.MetricAlerts(),
		premiummonitor.ScheduledQueryRules(),
		mysql.Servers(),
		mysqlflexibleservers.Servers(),
		netappfiles.Accounts(),
		netappfiles.QuotaLimits(),
		netappfiles.RegionInfos(),
		network.ApplicationGateways(),
		network.ApplicationSecurityGroups(),
		network.AzureFirewallFqdnTags(),
		network.AzureFirewalls(),
		network.BastionHosts(),
		network.BgpServiceCommunities(),
		network.CustomIpPrefixes(),
		network.DdosProtectionPlans(),
		network.DscpConfiguration(),
		network.ExpressRouteCircuits(),
		network.ExpressRouteGateways(),
		network.ExpressRoutePorts(),
		network.ExpressRoutePortsLocations(),
		network.ExpressRouteServiceProviders(),
		network.FirewallPolicies(),
		network.IpAllocations(),
		network.IpGroups(),
		network.Interfaces(),
		network.LoadBalancers(),
		network.NatGateways(),
		network.PrivateLinkServices(),
		network.PrivateEndpoints(),
		network.Profiles(),
		network.PublicIpAddresses(),
		network.PublicIpPrefixes(),
		network.RouteFilters(),
		network.RouteTables(),
		network.SecurityGroups(),
		network.SecurityPartnerProviders(),
		network.ServiceEndpointPolicies(),
		network.SubscriptionNetworkManagerConnections(),
		network.VpnGateways(),
		network.VpnServerConfigurations(),
		network.VpnSites(),
		network.VirtualAppliances(),
		network.VirtualHubs(),
		network.VirtualNetworkTaps(),
		network.VirtualNetworks(),
		network.VirtualNetworkGateways(),
		network.VirtualNetworkGatewayConnections(),
		network.VirtualRouters(),
		network.VirtualWans(),
		network.Watchers(),
		network.WebApplicationFirewallPolicies(),
		networkfunction.AzureTrafficCollectorsBySubscription(),
		nginx.Deployments(),
		notificationhubs.Namespaces(),
		operationalinsights.Clusters(),
		operationalinsights.Workspaces(),
		peering.ServiceCountries(),
		peering.ServiceLocations(),
		peering.ServiceProviders(),
		portal.ListTenantConfigurationViolations(),
		portal.TenantConfigurations(),
		postgresql.Servers(),
		postgresqlflexibleservers.Servers(),
		postgresqlhsc.ServerGroups(),
		powerbidedicated.Capacities(),
		privatedns.PrivateZones(),
		providerhub.ProviderRegistrations(),
		quota.Quotas(),
		quota.Usages(),
		redhatopenshift.OpenShiftClusters(),
		redis.Caches(),
		relay.Namespaces(),
		recoveryservices.Operations(),
		recoveryservices.Vaults(),
		reservations.Reservation(),
		reservations.ReservationOrder(),
		resources.Resources(),
		resources.ResourceGroups(),
		resources.Links(),
		resources.Providers(),
		resourcehealth.AvailabilityStatuses(),
		resourcehealth.EmergingIssues(),
		resourcehealth.Events(),
		policy.Assignments(),
		policy.DataPolicyManifests(),
		policy.Definitions(),
		policy.Exemptions(),
		policy.SetDefinitions(),
		policyinsights.Attestations(),
		policyinsights.PolicyEvents(),
		policyinsights.PolicyTrackedResources(),
		policyinsights.PolicyStates(),
		purview.Accounts(),
		purview.Operations(),
		saas.Resources(),
		search.Services(),
		security.AdaptiveApplicationControls(),
		security.Alerts(),
		security.AlertsSuppressionRules(),
		security.AllowedConnections(),
		security.Applications(),
		security.Assessments(),
		security.SubAssessments(),
		security.AssessmentsMetadata(),
		security.AutoProvisioningSettings(),
		security.Automations(),
		security.Connectors(),
		security.Contacts(),
		security.DiscoveredSecuritySolutions(),
		security.ExternalSecuritySolutions(),
		security.GovernanceRule(),
		security.JitNetworkAccessPolicies(),
		security.Locations(),
		security.Pricings(),
		security.RegulatoryComplianceStandards(),
		security.SecureScoreControlDefinitions(),
		security.SecureScoreControls(),
		security.SecureScores(),
		security.Settings(),
		security.Solutions(),
		security.Tasks(),
		security.Topology(),
		security.WorkspaceSettings(),
		servicebus.Namespaces(),
		servicefabric.Clusters(),
		servicefabricmanagedclusters.ManagedClusters(),
		sql.Servers(),
		sql.InstancePools(),
		sql.ManagedInstances(),
		sql.VirtualClusters(),
		sqlvirtualmachine.Groups(),
		sqlvirtualmachine.SqlVirtualMachines(),
		storage.Accounts(),
		storagecache.Caches(),
		storagemover.Operations(),
		storagemover.StorageMovers(),
		storagesync.Services(),
		streamanalytics.StreamingJobs(),
		subscription.Subscriptions(),
		subscription.Tenants(),
		support.Services(),
		support.Tickets(),
		synapse.PrivateLinkHubs(),
		synapse.Workspaces(),
		trafficmanager.Profiles(),
		windowsiot.Services(),
		workloads.Monitors(),
		databricks.AccessConnectors(),
		databricks.Operations(),
		databricks.Workspaces(),
	}
	for i := range list {
		if list[i].PostResourceResolver == nil {
			panic("no PostResourceResolver in " + list[i].Name)
		}
	}
	if err := transformers.TransformTables(list); err != nil {
		panic(err)
	}
	if err := transformers.Apply(list, titleTransformer); err != nil {
		panic(err)
	}
	applyTableOptionsDoc := tableOptionsDocTransformer()
	for _, table := range list {
		schema.AddCqIDs(table)
		if s != nil && s.AddCQClientID {
			schema.AddCqClientID(table)
		}
		applyTableOptionsDoc(table)
	}

	withIsPaid := premium.MakeAllTablesPaid(list)
	for _, free := range freeTables {
		t := withIsPaid.Get(free)
		if t == nil {
			panic("can't set table " + free + " as free")
		}
		t.IsPaid = false
	}
	return withIsPaid
}
