// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package access_applications

import (
	"testing"

	"github.com/cloudflare/cloudflare-go/v5/packages/pagination"
	"github.com/cloudflare/cloudflare-go/v5/zero_trust"
	"github.com/cloudquery/cloudquery/plugins/source/cloudflare/client"
	"github.com/cloudquery/cloudquery/plugins/source/cloudflare/client/mocks"
	"github.com/cloudquery/plugin-sdk/v4/faker"
	"github.com/stretchr/testify/require"
	"go.uber.org/mock/gomock"
)

func buildAccessApplications(t *testing.T, ctrl *gomock.Controller) client.CloudflareServices {
	mock := mocks.NewMockZeroTrustAccessApplicationServiceClient(ctrl)

	var resp zero_trust.AccessApplicationListResponse
	require.NoError(t, faker.FakeObject(&resp))
	var sh zero_trust.SelfHostedDomains
	require.NoError(t, faker.FakeObject(&sh))
	resp.SelfHostedDomains = []zero_trust.SelfHostedDomains{sh}

	mock.EXPECT().List(gomock.Any(), gomock.Any()).Return(
		&pagination.SinglePage[zero_trust.AccessApplicationListResponse]{
			Result: []zero_trust.AccessApplicationListResponse{resp},
		},
		nil,
	)
	return client.CloudflareServices{
		ZeroTrustAccessApplicationService: mock,
	}
}

func TestAccessApplications(t *testing.T) {
	client.MockTestHelper(t, AccessApplications(), buildAccessApplications)
}
