// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package dns_records

import (
	"testing"

	"github.com/cloudflare/cloudflare-go/v5/dns"
	"github.com/cloudflare/cloudflare-go/v5/packages/pagination"
	"github.com/cloudquery/cloudquery/plugins/source/cloudflare/client"
	"github.com/cloudquery/cloudquery/plugins/source/cloudflare/client/mocks"
	"github.com/cloudquery/plugin-sdk/v4/faker"
	"github.com/stretchr/testify/require"
	"go.uber.org/mock/gomock"
)

func buildDNSRecords(t *testing.T, ctrl *gomock.Controller) client.CloudflareServices {
	mock := mocks.NewMockDnsRecordServiceClient(ctrl)

	var record dns.RecordResponse

	require.NoError(t, faker.FakeObject(&record))
	record.Meta = map[string]any{"foo": "bar"}
	record.Data = map[string]any{"foo": "bar"}
	mock.EXPECT().List(
		gomock.Any(),
		gomock.Any()).
		Return(&pagination.V4PagePaginationArray[dns.RecordResponse]{
			Result: []dns.RecordResponse{record},
		}, nil).AnyTimes()

	return client.CloudflareServices{
		DnsRecordService: mock,
	}
}

func TestDNSRecords(t *testing.T) {
	client.MockTestHelper(t, DNSRecords(), buildDNSRecords)
}
