// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package images

import (
	"testing"

	"github.com/cloudflare/cloudflare-go/v5/images"
	"github.com/cloudquery/cloudquery/plugins/source/cloudflare/client"
	"github.com/cloudquery/cloudquery/plugins/source/cloudflare/client/mocks"
	"github.com/cloudquery/plugin-sdk/v4/faker"
	"github.com/stretchr/testify/require"
	"go.uber.org/mock/gomock"
)

func buildImages(t *testing.T, ctrl *gomock.Controller) client.CloudflareServices {
	mock := mocks.NewMockImagesV2ServiceClient(ctrl)

	var image images.Image
	require.NoError(t, faker.FakeObject(&image))
	image.Meta = map[string]any{"a": "b"}

	mock.EXPECT().List(
		gomock.Any(),
		gomock.Any()).
		Return(&images.V2ListResponse{
			Images:            []images.Image{image},
			ContinuationToken: "",
		}, nil).AnyTimes()

	return client.CloudflareServices{
		ImagesV2Service: mock,
	}
}

func TestImages(t *testing.T) {
	client.MockTestHelper(t, Images(), buildImages)
}
