// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package plugin

import (
	"slices"

	"github.com/cloudquery/cloudquery/plugins/source/gcp/client/spec"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/accessapproval"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/aiplatform"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/alloydb"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/apigateway"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/apikeys"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/appengine"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/applicationintegration"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/artifactregistry"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/baremetalsolution"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/batch"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/beyondcorp"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/bigquery"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/bigquerydatatransfer"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/bigtableadmin"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/billing"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/binaryauthorization"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/certificatemanager"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/cloudassetinventory"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/cloudbuild"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/clouddeploy"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/clouderrorreporting"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/cloudresourcemanager"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/cloudscheduler"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/cloudsupport"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/cloudtasks"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/cloudtrace"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/composer"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/compute"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/container"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/containeranalysis"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/databasemigration"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/dataflow"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/datafusion"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/dataproc"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/deploymentmanager"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/dns"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/domains"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/essentialcontacts"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/eventarc"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/filestore"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/firebaseappcheck"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/firebasehosting"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/firebaserules"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/firestore"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/functions"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/iam"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/identitytoolkit"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/kms"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/livestream"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/logging"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/looker"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/memorystore"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/monitoring"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/networkconnectivity"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/networkintelligencecenter"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/networksecurity"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/networkservices"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/organization"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/policyanalyzer"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/privateca"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/pubsub"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/recommendations"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/redis"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/resourcemanager"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/run"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/secretmanager"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/securitycenter"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/servicehealth"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/serviceusage"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/sourcerepo"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/spanner"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/sql"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/storage"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/storagetransfer"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/translate"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/videotranscoder"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/vision"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/vmmigration"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/vpcaccess"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/websecurityscanner"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/resources/services/workflows"
	"github.com/cloudquery/plugin-sdk/v4/premium"
	"github.com/cloudquery/plugin-sdk/v4/schema"
	"github.com/cloudquery/plugin-sdk/v4/transformers"
)

func getTables(s *spec.Spec) schema.Tables {
	tables := schema.Tables{
		accessapproval.FolderApprovalRequests(),
		accessapproval.FolderServiceAccounts(),
		accessapproval.FolderSettings(),
		accessapproval.OrganizationApprovalRequests(),
		accessapproval.OrganizationServiceAccounts(),
		accessapproval.OrganizationSettings(),
		accessapproval.ProjectApprovalRequests(),
		accessapproval.ProjectServiceAccounts(),
		accessapproval.ProjectSettings(),
		aiplatform.DatasetLocations(),
		aiplatform.EndpointLocations(),
		aiplatform.FeaturestoreLocations(),
		aiplatform.IndexEndpointLocations(),
		aiplatform.IndexLocations(),
		aiplatform.JobLocations(),
		aiplatform.MetadataLocations(),
		aiplatform.ModelLocations(),
		aiplatform.Operations(),
		aiplatform.PipelineLocations(),
		aiplatform.SpecialistpoolLocations(),
		aiplatform.TensorboardLocations(),
		aiplatform.VizierLocations(),
		alloydb.Clusters(),
		alloydb.Instances(),
		apigateway.Apis(),
		apigateway.Gateways(),
		apikeys.Keys(),
		appengine.Apps(),
		appengine.AuthorizedCertificates(),
		appengine.AuthorizedDomains(),
		appengine.DomainMappings(),
		appengine.FirewallIngressRules(),
		appengine.Services(),
		applicationintegration.AuthConfigs(),
		applicationintegration.Certificates(),
		applicationintegration.Integrations(),
		applicationintegration.SfdcInstances(),
		artifactregistry.Locations(),
		baremetalsolution.Instances(),
		baremetalsolution.Networks(),
		baremetalsolution.NfsShares(),
		baremetalsolution.Volumes(),
		batch.Jobs(),
		batch.TaskGroups(),
		beyondcorp.AppConnections(),
		beyondcorp.AppConnectors(),
		beyondcorp.AppGateways(),
		bigquery.Datasets(),
		bigquerydatatransfer.DataSources(),
		bigquerydatatransfer.Locations(),
		bigquerydatatransfer.Configs(),
		bigtableadmin.Instances(),
		billing.BillingAccounts(),
		billing.Projects(),
		billing.Services(),
		binaryauthorization.Assertors(),
		certificatemanager.CertificateIssuanceConfigs(),
		certificatemanager.CertificateMaps(),
		certificatemanager.Certificates(),
		certificatemanager.DnsAuthorizations(),
		cloudassetinventory.Assets(),
		cloudassetinventory.Feeds(),
		cloudassetinventory.SavedQueries(),
		cloudbuild.Builds(),
		cloudbuild.Connections(),
		cloudbuild.Triggers(),
		cloudbuild.WorkerPools(),
		clouddeploy.DeliveryPipelines(),
		clouddeploy.Targets(),
		clouderrorreporting.ErrorGroupStats(),
		cloudresourcemanager.Organizations(),
		cloudscheduler.Locations(),
		cloudsupport.Cases(),
		cloudtasks.Locations(),
		cloudtrace.Traces(),
		composer.Environments(),
		composer.ImageVersions(),
		composer.Operations(),
		compute.Addresses(),
		compute.Autoscalers(),
		compute.BackendBuckets(),
		compute.BackendServices(),
		compute.Disks(),
		compute.DiskTypes(),
		compute.ExternalVpnGateways(),
		compute.Firewalls(),
		compute.ForwardingRules(),
		compute.GlobalAddresses(),
		compute.GlobalForwardingRules(),
		compute.HealthChecks(),
		compute.Images(),
		compute.InstanceGroupManagers(),
		compute.InstanceGroups(),
		compute.Instances(),
		compute.InterconnectLocations(),
		compute.InterconnectRemoteLocations(),
		compute.Interconnects(),
		compute.NetworkEndpointGroups(),
		compute.Networks(),
		compute.OsConfigPatchDeployments(),
		compute.OsConfigPatchJobs(),
		compute.PacketMirrorings(),
		compute.Projects(),
		compute.Routers(),
		compute.Routes(),
		compute.Snapshots(),
		compute.SecurityPolicies(),
		compute.SslCertificates(),
		compute.SslPolicies(),
		compute.Subnetworks(),
		compute.TargetHttpProxies(),
		compute.TargetInstances(),
		compute.TargetPools(),
		compute.TargetGrpcProxies(),
		compute.TargetHttpsProxies(),
		compute.TargetSslProxies(),
		compute.TargetTcpProxies(),
		compute.TargetVpnGateways(),
		compute.UrlMaps(),
		compute.VpnGateways(),
		compute.VpnTunnels(),
		compute.Zones(),
		container.Clusters(),
		containeranalysis.Occurrences(),
		dataflow.Jobs(),
		dataflow.Snapshots(),
		datafusion.AvailableVersions(),
		datafusion.Instances(),
		dataproc.Regions(),
		deploymentmanager.Deployments(),
		deploymentmanager.Operations(),
		deploymentmanager.Types(),
		dns.ManagedZones(),
		dns.Policies(),
		databasemigration.Locations(),
		domains.Registrations(),
		essentialcontacts.FolderContacts(),
		essentialcontacts.OrgContacts(),
		essentialcontacts.ProjectContacts(),
		eventarc.Channels(),
		eventarc.Providers(),
		eventarc.Triggers(),
		filestore.Backups(),
		filestore.Instances(),
		filestore.Locations(),
		filestore.Operations(),
		filestore.Snapshots(),
		firebaseappcheck.AppAttestConfig(),
		firebaseappcheck.DeviceCheckConfigs(),
		firebaseappcheck.PlayIntegrityConfigs(),
		firebaseappcheck.RecaptchaConfigs(),
		firebaseappcheck.RecaptchaEnterpriseConfigs(),
		firebaseappcheck.SafetyNetConfigs(),
		firebasehosting.Sites(),
		firebaserules.Releases(),
		firebaserules.Rulesets(),
		firestore.Databases(),
		functions.Functions(),
		functions.FunctionsV2(),
		iam.DenyPolicies(),
		iam.OrganizationalRoles(),
		iam.PredefinedRoles(),
		iam.Roles(),
		iam.ServiceAccounts(),
		iam.WorkloadIdentityPools(),
		identitytoolkit.Accounts(),
		identitytoolkit.DefaultSupportedIDPs(),
		identitytoolkit.InboundSAMLConfigs(),
		identitytoolkit.OAuthIDPConfigs(),
		identitytoolkit.ProjectConfigs(),
		identitytoolkit.ProjectPublicConfigs(),
		identitytoolkit.RecaptchaParams(),
		identitytoolkit.Tenants(),
		kms.Locations(),
		livestream.Channels(),
		livestream.Inputs(),
		logging.Metrics(),
		logging.Sinks(),
		looker.Instances(),
		memorystore.Locations(),
		monitoring.AlertPolicies(),
		networkconnectivity.Locations(),
		networkintelligencecenter.ConnectivityTests(),
		networkintelligencecenter.Locations(),
		networkintelligencecenter.Operations(),
		networksecurity.AddressGroups(),
		networksecurity.FirewallEndpoints(),
		networksecurity.SecurityProfileGroups(),
		networksecurity.SecurityProfiles(),
		networksecurity.TLSInspectionPolicies(),
		networkservices.EndpointPolicies(),
		networkservices.Gateways(),
		networkservices.GrpcRoutes(),
		networkservices.HttpRoutes(),
		networkservices.Meshes(),
		networkservices.ServiceBindings(),
		networkservices.TcpRoutes(),
		networkservices.TlsRoutes(),
		policyanalyzer.Activities(),
		organization.OrganizationPolicies(),
		organization.ProjectsPolicies(),
		organization.FoldersPolicies(),
		pubsub.Schemas(),
		pubsub.Snapshots(),
		pubsub.Subscriptions(),
		pubsub.Topics(),
		privateca.Pools(),
		recommendations.Folders(),
		recommendations.FoldersLocations(),
		recommendations.Organizations(),
		recommendations.OrganizationsLocations(),
		recommendations.Projects(),
		recommendations.ProjectsLocations(),
		redis.Instances(),
		resourcemanager.FolderPolicies(),
		resourcemanager.Folders(),
		resourcemanager.OrganizationPolicies(),
		resourcemanager.OrganizationTagKeys(),
		resourcemanager.ProjectPolicies(),
		resourcemanager.Projects(),
		resourcemanager.ProjectTagBindings(),
		resourcemanager.ProjectTagKeys(),
		run.Locations(),
		secretmanager.Secrets(),
		securitycenter.FolderFindings(),
		securitycenter.OrganizationFindings(),
		securitycenter.ProjectFindings(),
		securitycenter.FolderEventThreatDetectionSettings(),
		securitycenter.OrganizationEventThreatDetectionSettings(),
		securitycenter.ProjectEventThreatDetectionSettings(),
		servicehealth.Locations(),
		services.Projects(),
		serviceusage.Services(),
		sourcerepo.Config(),
		sourcerepo.Repos(),
		spanner.Instances(),
		sql.Instances(),
		storage.Buckets(),
		storage.HMACKeys(),
		storagetransfer.AgentPools(),
		storagetransfer.TransferJobs(),
		storagetransfer.TransferOperations(),
		translate.Glossaries(),
		videotranscoder.Jobs(),
		videotranscoder.JobTemplates(),
		vision.Products(),
		vmmigration.Groups(),
		vmmigration.Sources(),
		vmmigration.TargetProjects(),
		vpcaccess.Locations(),
		websecurityscanner.ScanConfigs(),
		workflows.Workflows(),
	}
	if err := transformers.TransformTables(tables); err != nil {
		panic(err)
	}
	if err := transformers.Apply(tables, titleTransformer, descriptionTransformer()); err != nil {
		panic(err)
	}
	for _, table := range tables {
		schema.AddCqIDs(table)
		if s != nil && s.AddCQClientID {
			schema.AddCqClientID(table)
		}
	}
	markPaid(tables, s)
	return tables
}

func markPaid(tables schema.Tables, s *spec.Spec) {
	premium.MakeAllTablesPaid(tables)
	makeFree(tables)

	if s == nil || s.TableOptions == nil {
		return
	}

	set := s.TableOptions.TablesSet()
	if len(set) == 0 {
		return
	}

	toUpdate := make(schema.Tables, 0, len(set))
	for _, name := range set {
		table := tables.Get(name)
		if table != nil {
			toUpdate = append(toUpdate, table)
		}
	}

	premium.MakeAllTablesPaid(toUpdate)
}

var freeTables = []string{
	"gcp_compute_disk_types",
	"gcp_compute_interconnect_locations",
	"gcp_compute_interconnect_remote_locations",
	"gcp_compute_zones",
	"gcp_compute_machine_types",
}

func makeFree(tables schema.Tables) {
	for _, t := range tables {
		if slices.Contains(freeTables, t.Name) {
			t.IsPaid = false
		}
		makeFree(t.Relations)
	}
}
