// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package compute

import (
	pb "cloud.google.com/go/compute/apiv1/computepb"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client/permissions"
	"github.com/cloudquery/plugin-sdk/v4/schema"
	"github.com/cloudquery/plugin-sdk/v4/transformers"
)

func Projects() *schema.Table {
	return &schema.Table{
		Name:              "gcp_compute_projects",
		Description:       `https://cloud.google.com/compute/docs/reference/rest/v1/projects#resource:-project`,
		Resolver:          fetchProjects,
		PermissionsNeeded: permissions.NewList(permissions.ComputeProjectsGet),
		Multiplex:         client.ProjectMultiplexEnabledServices("compute.googleapis.com"),
		Transform:         client.TransformWithStruct(&pb.Project{}, transformers.WithPrimaryKeys("SelfLink")),
		Columns: []schema.Column{
			client.ProjectIDColumn(false),
		},
	}
}
