// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package dns

import (
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client/permissions"
	"github.com/cloudquery/plugin-sdk/v4/schema"
	"github.com/cloudquery/plugin-sdk/v4/transformers"
	pb "google.golang.org/api/dns/v1"
)

func ManagedZones() *schema.Table {
	return &schema.Table{
		Name:              "gcp_dns_managed_zones",
		Description:       `https://cloud.google.com/dns/docs/reference/v1/managedZones#resource`,
		Resolver:          fetchManagedZones,
		PermissionsNeeded: permissions.NewList(permissions.DnsManagedZonesList),
		Multiplex:         client.ProjectMultiplexEnabledServices("dns.googleapis.com"),
		Transform: client.TransformWithStruct(&pb.ManagedZone{},
			transformers.WithPrimaryKeys("Name"), // as relation uses this
		),
		Columns:   schema.ColumnList{client.ProjectIDColumn(true)},
		Relations: schema.Tables{resourceRecordSets()},
	}
}
