// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package dns

import (
	"github.com/apache/arrow-go/v18/arrow"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client/permissions"
	"github.com/cloudquery/plugin-sdk/v4/schema"
	"github.com/cloudquery/plugin-sdk/v4/transformers"
	"google.golang.org/api/dns/v1"
)

func resourceRecordSets() *schema.Table {
	return &schema.Table{
		Name:              "gcp_dns_resource_record_sets",
		Description:       `https://cloud.google.com/dns/docs/reference/v1/resourceRecordSets`,
		Resolver:          fetchResourceRecordSets,
		PermissionsNeeded: permissions.NewList(permissions.DnsResourceRecordSetsList),
		Transform:         client.TransformWithStruct(&dns.ResourceRecordSet{}, transformers.WithPrimaryKeys("Name", "Type")),
		Columns: []schema.Column{
			client.ProjectIDColumn(true),
			{
				Name:       "managed_zone_name",
				Type:       arrow.BinaryTypes.String,
				Resolver:   schema.ParentColumnResolver("name"),
				PrimaryKey: true,
			},
		},
	}
}
