// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package iam

import (
	pb "cloud.google.com/go/iam/apiv2/iampb"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client/permissions"
	"github.com/cloudquery/plugin-sdk/v4/schema"
	"github.com/cloudquery/plugin-sdk/v4/transformers"
)

func DenyPolicies() *schema.Table {
	return &schema.Table{
		Name:              "gcp_iam_deny_policies",
		Description:       `https://cloud.google.com/iam/docs/reference/rest/v2beta/policies#Policy`,
		Resolver:          fetchDenyPolicies,
		PermissionsNeeded: permissions.NewList(permissions.IamDenypoliciesList),
		Multiplex:         client.ProjectMultiplexEnabledServices("iam.googleapis.com"),
		Transform:         client.TransformWithStruct(&pb.Policy{}, transformers.WithPrimaryKeys("Name")),
		Columns: []schema.Column{
			client.ProjectIDColumn(true),
		},
	}
}
