// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package iam

import (
	"context"
	"fmt"
	"testing"

	"github.com/cloudquery/cloudquery/plugins/source/gcp/client"
	"github.com/cloudquery/plugin-sdk/v4/faker"
	"google.golang.org/grpc"

	pb "cloud.google.com/go/iam/apiv2/iampb"
)

func createDenyPolicies(gsrv *grpc.Server) error {
	fakeServer := &fakeDenyPoliciesServer{}
	pb.RegisterPoliciesServer(gsrv, fakeServer)
	return nil
}

type fakeDenyPoliciesServer struct {
	pb.UnimplementedPoliciesServer
}

func (*fakeDenyPoliciesServer) ListPolicies(context.Context, *pb.ListPoliciesRequest) (*pb.ListPoliciesResponse, error) {
	resp := pb.ListPoliciesResponse{}
	if err := faker.FakeObject(&resp); err != nil {
		return nil, fmt.Errorf("failed to fake data: %w", err)
	}
	resp.NextPageToken = ""
	return &resp, nil
}

func TestDenyPolicies(t *testing.T) {
	client.MockTestHelper(t, DenyPolicies(), client.WithCreateGrpcService(createDenyPolicies))
}
