// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package iam

import (
	"context"
	"fmt"

	iampb "cloud.google.com/go/iam/admin/apiv1/adminpb"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client/permissions"
	"github.com/cloudquery/plugin-sdk/v4/schema"
	"github.com/cloudquery/plugin-sdk/v4/transformers"
)

func Roles() *schema.Table {
	return &schema.Table{
		Name:              "gcp_iam_roles",
		Description:       `https://cloud.google.com/iam/docs/reference/rest/v1/roles#Role`,
		Resolver:          resolveProjectsIAMRole,
		PermissionsNeeded: permissions.NewList(permissions.IamRolesList),
		Multiplex:         client.ProjectMultiplexEnabledServices("iam.googleapis.com"),
		Transform:         client.TransformWithStruct(&iampb.Role{}, transformers.WithPrimaryKeys("Name")),
		Columns: []schema.Column{
			client.ProjectIDColumn(true),
		},
	}
}

func resolveProjectsIAMRole(ctx context.Context, meta schema.ClientMeta, r *schema.Resource, res chan<- any) error {
	c := meta.(*client.Client)
	parent := fmt.Sprintf("projects/%s", c.ProjectId)
	return fetchIAMRole(ctx, meta, r, res, parent)
}
