// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package iam

import (
	"context"
	"errors"
	"fmt"
	"strings"
	"testing"

	pb "cloud.google.com/go/iam/admin/apiv1/adminpb"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client"
	"github.com/cloudquery/plugin-sdk/v4/faker"
	"google.golang.org/grpc"
)

func createProjectRoles(gsrv *grpc.Server) error {
	fakeServer := &fakeProjectRolesServer{}
	pb.RegisterIAMServer(gsrv, fakeServer)
	return nil
}

type fakeProjectRolesServer struct {
	pb.UnimplementedIAMServer
}

func (*fakeProjectRolesServer) ListRoles(ctx context.Context, req *pb.ListRolesRequest) (*pb.ListRolesResponse, error) {
	if req == nil {
		return nil, errors.New("request is nil")
	}
	if !strings.HasPrefix(req.Parent, "projects/") {
		return nil, errors.New("wrong parent")
	}

	resp := pb.ListRolesResponse{}
	if err := faker.FakeObject(&resp); err != nil {
		return nil, fmt.Errorf("failed to fake data: %w", err)
	}
	resp.NextPageToken = ""
	return &resp, nil
}

func TestRoles(t *testing.T) {
	client.MockTestHelper(t, Roles(), client.WithCreateGrpcService(createProjectRoles))
}
