// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package iam

import (
	pb "cloud.google.com/go/iam/admin/apiv1/adminpb"
	"github.com/apache/arrow-go/v18/arrow"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client/permissions"
	"github.com/cloudquery/plugin-sdk/v4/schema"
	"github.com/cloudquery/plugin-sdk/v4/transformers"
)

func serviceAccountKeys() *schema.Table {
	return &schema.Table{
		Name:              "gcp_iam_service_account_keys",
		Description:       `https://cloud.google.com/iam/docs/reference/rest/v1/projects.serviceAccounts.keys#ServiceAccountKey`,
		Resolver:          fetchServiceAccountKeys,
		PermissionsNeeded: permissions.NewList(permissions.IamServiceAccountKeysList),
		Transform:         client.TransformWithStruct(&pb.ServiceAccountKey{}, transformers.WithSkipFields("PrivateKeyData", "PrivateKeyType"), transformers.WithPrimaryKeys("Name")),
		Columns: []schema.Column{
			client.ProjectIDColumn(true),
			{
				Name:     "service_account_unique_id",
				Type:     arrow.BinaryTypes.String,
				Resolver: schema.ParentColumnResolver("unique_id"),
			},
		},
	}
}
