// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package iam

import (
	"context"

	iamadmin "cloud.google.com/go/iam/admin/apiv1"
	iampb "cloud.google.com/go/iam/admin/apiv1/adminpb"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client"
	"github.com/cloudquery/plugin-sdk/v4/schema"
	"google.golang.org/api/option"
)

func fetchServiceAccountKeys(ctx context.Context, meta schema.ClientMeta, parent *schema.Resource, res chan<- any) error {
	c := meta.(*client.Client)
	p := parent.Item.(*iampb.ServiceAccount)

	options := make([]option.ClientOption, len(c.ClientOptions))
	copy(options, c.ClientOptions)
	if c.TestingGRPCEndpoint != nil {
		options = append(options, option.WithEndpoint(*c.TestingGRPCEndpoint))
	}

	iamClient, err := iamadmin.NewIamClient(ctx, options...)
	if err != nil {
		return err
	}
	iamClient.CallOptions = &iamadmin.IamCallOptions{}

	req := &iampb.ListServiceAccountKeysRequest{
		Name: p.Name,
	}

	output, err := iamClient.ListServiceAccountKeys(ctx, req, c.CallOptions...)
	if err != nil {
		return err
	}

	res <- output.Keys
	return nil
}
