// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package resourcemanager

import (
	pb "cloud.google.com/go/resourcemanager/apiv3/resourcemanagerpb"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client"
	"github.com/cloudquery/plugin-sdk/v4/schema"
	"github.com/cloudquery/plugin-sdk/v4/transformers"
)

func OrganizationTagKeys() *schema.Table {
	return &schema.Table{
		Name:        "gcp_resourcemanager_organization_tag_keys",
		Description: `https://cloud.google.com/resource-manager/reference/rest/v3/tagKeys/list`,
		Resolver:    fetchOrganizationTagKeys,
		Multiplex:   client.OrgMultiplex,
		Transform:   client.TransformWithStruct(&pb.TagKey{}, transformers.WithPrimaryKeys("Name")),
		Columns:     schema.ColumnList{client.OrganizationIDColumn(true)},
		Relations:   schema.Tables{organizationTagValues()},
	}
}

func organizationTagValues() *schema.Table {
	return &schema.Table{
		Name:        "gcp_resourcemanager_organization_tag_values",
		Description: `https://cloud.google.com/resource-manager/reference/rest/v3/tagValues/list`,
		Resolver:    fetchOrganizationTagValues,
		Transform:   client.TransformWithStruct(&pb.TagValue{}, transformers.WithPrimaryKeys("Parent", "Name")),
		Columns:     schema.ColumnList{client.OrganizationIDColumn(true)},
	}
}
