// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package resourcemanager

import (
	"context"

	resourcemanager "cloud.google.com/go/resourcemanager/apiv3"
	pb "cloud.google.com/go/resourcemanager/apiv3/resourcemanagerpb"
	"github.com/cloudquery/cloudquery/plugins/source/gcp/client"
	"github.com/cloudquery/plugin-sdk/v4/schema"
)

func fetchOrganizationTagKeys(ctx context.Context, meta schema.ClientMeta, parent *schema.Resource, res chan<- any) error {
	c := meta.(*client.Client)

	fClient, err := resourcemanager.NewTagKeysClient(ctx, c.ClientOptions...)
	if err != nil {
		return err
	}

	req := &pb.ListTagKeysRequest{
		Parent: "organizations/" + c.OrgId,
	}
	it := fClient.ListTagKeys(ctx, req, c.CallOptions...)
	return client.Iterate(ctx, it, c, res)
}

func fetchOrganizationTagValues(ctx context.Context, meta schema.ClientMeta, parent *schema.Resource, res chan<- any) error {
	c := meta.(*client.Client)

	fClient, err := resourcemanager.NewTagValuesClient(ctx, c.ClientOptions...)
	if err != nil {
		return err
	}

	var parentName string
	if parent != nil {
		parentName = parent.Item.(*pb.TagKey).Name
	}
	req := &pb.ListTagValuesRequest{
		Parent: parentName,
	}

	it := fClient.ListTagValues(ctx, req, c.CallOptions...)
	return client.Iterate(ctx, it, c, res)
}
