// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package plugin

import (
	"github.com/cloudquery/cloudquery/plugins/source/github/client"
	"github.com/cloudquery/cloudquery/plugins/source/github/resources/services/actions"
	"github.com/cloudquery/cloudquery/plugins/source/github/resources/services/billing"
	"github.com/cloudquery/cloudquery/plugins/source/github/resources/services/code_scanning"
	"github.com/cloudquery/cloudquery/plugins/source/github/resources/services/copilot"
	enterpriseidentityprovider "github.com/cloudquery/cloudquery/plugins/source/github/resources/services/enterprise_identity_provider"
	"github.com/cloudquery/cloudquery/plugins/source/github/resources/services/external"
	"github.com/cloudquery/cloudquery/plugins/source/github/resources/services/hooks"
	"github.com/cloudquery/cloudquery/plugins/source/github/resources/services/installations"
	"github.com/cloudquery/cloudquery/plugins/source/github/resources/services/issues"
	"github.com/cloudquery/cloudquery/plugins/source/github/resources/services/organizations"
	pullrequestclosingissuesreferences "github.com/cloudquery/cloudquery/plugins/source/github/resources/services/pull_request_closing_issues_references"
	pullrequests "github.com/cloudquery/cloudquery/plugins/source/github/resources/services/pull_requests"
	"github.com/cloudquery/cloudquery/plugins/source/github/resources/services/repositories"
	"github.com/cloudquery/cloudquery/plugins/source/github/resources/services/secret_scanning"
	"github.com/cloudquery/cloudquery/plugins/source/github/resources/services/teams"
	"github.com/cloudquery/cloudquery/plugins/source/github/resources/services/traffic"
	"github.com/cloudquery/plugin-sdk/v4/docs"
	"github.com/cloudquery/plugin-sdk/v4/premium"
	"github.com/cloudquery/plugin-sdk/v4/schema"
	"github.com/cloudquery/plugin-sdk/v4/transformers"
)

func getTables(spec *client.Spec) []*schema.Table {
	tables := []*schema.Table{
		actions.Workflows(),
		actions.WorkflowRuns(),
		billing.Action(),
		billing.Storage(),
		billing.Package(),
		copilot.Billing(),
		copilot.OrganizationMetrics(),
		copilot.Seats(),
		code_scanning.Alerts(),
		enterpriseidentityprovider.SamlIdentities(),
		external.Groups(),
		issues.Issues(),
		hooks.Hooks(),
		installations.Installations(),
		organizations.Organizations(),
		pullrequestclosingissuesreferences.PullRequestClosingIssuesReferences(),
		pullrequests.PullRequests(),
		repositories.Repositories(),
		secret_scanning.Alerts(),
		teams.Teams(),
		traffic.Clones(),
		traffic.Paths(),
		traffic.Views(),
		traffic.Referrers(),
	}

	if err := transformers.TransformTables(tables); err != nil {
		panic(err)
	}
	if err := transformers.Apply(tables, func(t *schema.Table) error {
		t.Title = docs.DefaultTitleTransformer(t)
		return nil
	}); err != nil {
		panic(err)
	}
	for _, t := range tables {
		schema.AddCqIDs(t)
		if spec != nil && spec.AddCQClientID {
			schema.AddCqClientID(t)
		}
	}

	return premium.MakeAllTablesPaid(tables)
}
