// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package external

import (
	"testing"

	"github.com/cloudquery/cloudquery/plugins/source/github/client"
	"github.com/cloudquery/cloudquery/plugins/source/github/client/mocks"
	"github.com/cloudquery/cloudquery/plugins/source/github/client/services"
	"github.com/cloudquery/plugin-sdk/v4/faker"
	"github.com/golang/mock/gomock"
	"github.com/google/go-github/v69/github"
	"github.com/stretchr/testify/require"
)

func buildExternalGroups(t *testing.T, ctrl *gomock.Controller) services.Github {
	mock := mocks.NewMockGithubTeamsService(ctrl)

	var cs *github.ExternalGroupList
	require.NoError(t, faker.FakeObject(&cs))
	mock.EXPECT().ListExternalGroups(gomock.Any(), "testorg", gomock.Any()).Return(cs, &github.Response{}, nil)
	return services.Github{Teams: mock}
}

func TestExternalGroups(t *testing.T) {
	client.GithubMockTestHelper(t, Groups(), buildExternalGroups, client.TestOptions{})
}
