// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package installations

import (
	"testing"

	"github.com/cloudquery/cloudquery/plugins/source/github/client"
	"github.com/cloudquery/cloudquery/plugins/source/github/client/mocks"
	"github.com/cloudquery/cloudquery/plugins/source/github/client/services"
	"github.com/cloudquery/plugin-sdk/v4/faker"
	"github.com/golang/mock/gomock"
	"github.com/google/go-github/v69/github"
	"github.com/stretchr/testify/require"
)

func buildInstallations(t *testing.T, ctrl *gomock.Controller) services.Github {
	mock := mocks.NewMockGithubOrganizationsService(ctrl)

	var cs github.Installation
	require.NoError(t, faker.FakeObject(&cs))
	total := 1
	mock.EXPECT().ListInstallations(gomock.Any(), "testorg", gomock.Any()).Return(
		&github.OrganizationInstallations{TotalCount: &total, Installations: []*github.Installation{&cs}}, &github.Response{}, nil)

	return services.Github{Organizations: mock}
}

func TestInstallations(t *testing.T) {
	client.GithubMockTestHelper(t, Installations(), buildInstallations, client.TestOptions{})
}
