// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package issues

import (
	"testing"

	"github.com/cloudquery/cloudquery/plugins/source/github/client"
	"github.com/cloudquery/cloudquery/plugins/source/github/client/mocks"
	"github.com/cloudquery/cloudquery/plugins/source/github/client/services"
	"github.com/cloudquery/plugin-sdk/v4/faker"
	"github.com/golang/mock/gomock"
	"github.com/google/go-github/v69/github"
	"github.com/stretchr/testify/require"
)

func buildIssues(t *testing.T, ctrl *gomock.Controller) services.Github {
	mock := mocks.NewMockGithubIssuesService(ctrl)

	var cs github.Issue
	require.NoError(t, faker.FakeObject(&cs))
	someId := int64(5555555)
	cs.Repository = &github.Repository{ID: &someId}

	mock.EXPECT().ListByRepo(gomock.Any(), "testorg", gomock.Any(), gomock.Any()).Return(
		[]*github.Issue{&cs}, &github.Response{}, nil)

	var timeline github.Timeline
	require.NoError(t, faker.FakeObject(&timeline))

	mock.EXPECT().ListIssueTimeline(gomock.Any(), "testorg", gomock.Any(), gomock.Any(), gomock.Any()).Return(
		[]*github.Timeline{&timeline}, &github.Response{}, nil)

	reviews := mocks.NewMockGithubPullRequestsService(ctrl)

	var review github.PullRequestReview
	require.NoError(t, faker.FakeObject(&review))

	reviews.EXPECT().ListReviews(gomock.Any(), "testorg", gomock.Any(), gomock.Any(), gomock.Any()).Return(
		[]*github.PullRequestReview{&review}, &github.Response{}, nil)

	return services.Github{Issues: mock, PullRequests: reviews}
}

func TestIssues(t *testing.T) {
	client.GithubMockTestHelper(t, Issues(), buildIssues, client.TestOptions{})
}
