// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package organizations

import (
	"testing"

	"github.com/cloudquery/cloudquery/plugins/source/github/client/mocks"
	"github.com/cloudquery/cloudquery/plugins/source/github/client/services"
	"github.com/cloudquery/plugin-sdk/v4/faker"
	"github.com/golang/mock/gomock"
	"github.com/google/go-github/v69/github"
	"github.com/stretchr/testify/require"
)

func buildDependabot(t *testing.T, ctrl *gomock.Controller) services.GithubDependabotService {
	mock := mocks.NewMockGithubDependabotService(ctrl)

	var alert github.DependabotAlert
	require.NoError(t, faker.FakeObject(&alert))
	mock.EXPECT().ListOrgAlerts(gomock.Any(), gomock.Any(), gomock.Any()).Return(
		[]*github.DependabotAlert{&alert}, &github.Response{}, nil)

	var secret github.Secret
	require.NoError(t, faker.FakeObject(&secret))
	mock.EXPECT().ListOrgSecrets(gomock.Any(), gomock.Any(), gomock.Any()).Return(
		&github.Secrets{TotalCount: 1, Secrets: []*github.Secret{&secret}}, &github.Response{}, nil)

	return mock
}
