// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package traffic

import (
	"context"

	"github.com/cloudquery/cloudquery/plugins/source/github/client"
	"github.com/cloudquery/plugin-sdk/v4/schema"
	"github.com/google/go-github/v69/github"
)

func Clones() *schema.Table {
	return &schema.Table{
		Name:        "github_traffic_clones",
		Description: "https://docs.github.com/en/rest/metrics/traffic?apiVersion=2022-11-28#get-repository-clones",
		Resolver:    fetchClones,
		Multiplex:   client.OrgRepositoryMultiplex,
		Transform:   client.TransformWithStruct(&github.TrafficClones{}),
		Columns:     []schema.Column{client.OrgColumn, client.RepositoryIDColumn},
		IsPaid:      true,
	}
}

func fetchClones(ctx context.Context, meta schema.ClientMeta, _ *schema.Resource, res chan<- any) error {
	c := meta.(*client.Client)
	repo := c.Repository
	opts := &github.TrafficBreakdownOptions{}
	clones, _, err := c.Github.Repositories.ListTrafficClones(ctx, *repo.Owner.Login, *c.Repository.Name, opts)
	if err != nil {
		return err
	}
	res <- clones
	return nil
}
