// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package traffic

import (
	"testing"

	"github.com/cloudquery/cloudquery/plugins/source/github/client"
	"github.com/cloudquery/cloudquery/plugins/source/github/client/mocks"
	"github.com/cloudquery/cloudquery/plugins/source/github/client/services"
	"github.com/cloudquery/plugin-sdk/v4/faker"
	"github.com/golang/mock/gomock"
	"github.com/google/go-github/v69/github"
	"github.com/stretchr/testify/require"
)

func buildReferrers(t *testing.T, ctrl *gomock.Controller) services.Github {
	repositoriesMock := mocks.NewMockGithubRepositoriesService(ctrl)

	var referrers []*github.TrafficReferrer
	require.NoError(t, faker.FakeObject(&referrers))

	repositoriesMock.EXPECT().ListTrafficReferrers(gomock.Any(), "test string", "test string").Return(referrers, nil, nil)
	return services.Github{Repositories: repositoriesMock}
}

func TestReferrers(t *testing.T) {
	client.GithubMockTestHelper(t, Referrers(), buildReferrers, client.TestOptions{})
}
