// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package traffic

import (
	"testing"

	"github.com/cloudquery/cloudquery/plugins/source/github/client"
	"github.com/cloudquery/cloudquery/plugins/source/github/client/mocks"
	"github.com/cloudquery/cloudquery/plugins/source/github/client/services"
	"github.com/cloudquery/plugin-sdk/v4/faker"
	"github.com/golang/mock/gomock"
	"github.com/google/go-github/v69/github"
	"github.com/stretchr/testify/require"
)

func buildViews(t *testing.T, ctrl *gomock.Controller) services.Github {
	repositoriesMock := mocks.NewMockGithubRepositoriesService(ctrl)

	var views *github.TrafficViews
	require.NoError(t, faker.FakeObject(&views))

	opts := github.TrafficBreakdownOptions{}

	repositoriesMock.EXPECT().ListTrafficViews(gomock.Any(), "test string", "test string", &opts).Return(views, nil, nil)
	return services.Github{Repositories: repositoriesMock}
}

func TestViews(t *testing.T) {
	client.GithubMockTestHelper(t, Views(), buildViews, client.TestOptions{})
}
