// Copyright CloudQuery Authors
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.

package plugin

import (
	"github.com/cloudquery/cloudquery/plugins/source/k8s/client/spec"
	"github.com/cloudquery/plugin-sdk/v4/plugin"
)

var (
	Name    = "k8s"
	Kind    = "source"
	Team    = "cloudquery"
	Version = "development"
)

func Plugin() *plugin.Plugin {
	return plugin.NewPlugin(
		Name,
		Version,
		newClient,
		plugin.WithBuildTargets(buildTargets()),
		plugin.WithJSONSchema(spec.JSONSchema),
		plugin.WithKind(Kind),
		plugin.WithTeam(Team),
		plugin.WithConnectionTester(NewConnectionTester(newClient)),
	)
}
